/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
*
*  Filename: JCFMeeting.h
*
*  Generated on 
*
*  Copyright  Cisco Systems, Inc., All rights reserved.
*  170 West Tasman Drive, San Jose, California, 95134, USA
*
*  CONFIDENTIAL AND PROPRIETARY INFORMATION - DO NOT DISCLOSE
*
******************************************************************************/

#import "ObjCHelpers.h"
#import "ObjcWrapperCache.h"
#import "CSISecureString.h"
#import <Foundation/NSDate.h>
#import "ObjectFoundry.h"
#import <objc/runtime.h>

#import "JCFUnifiedBusinessObject.h"
#import "JCFMeeting.h"
#import "JCFMeetingParticipant.h"
#include "csfunified/services/interface/MeetingParticipant.h"

//cpp interface
#include "csfunified/services/interface/Meeting.h" 



NSString * const JCFMeetingNameDidChangeNotification = @"JCFMeetingNameDidChangeNotification";
NSString * const JCFMeetingParticipantsDidChangeNotification = @"JCFMeetingParticipantsDidChangeNotification";

#include <map>

typedef SMART_PTR_NS::shared_ptr<CSFUnified::Meeting> MeetingPtr;
typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingObserver> MeetingObserverPtr;

typedef SMART_PTR_NS::weak_ptr<CSFUnified::Meeting> MeetingWPtr;
typedef std::owner_less<MeetingWPtr> wp_less;
typedef std::map<MeetingWPtr, JCFMeeting*, wp_less> MeetingCache;
static MeetingCache sCache;

@interface JCFMeeting ()

@property (nonatomic, readwrite, assign) struct MeetingOpaque *cpp;

-(id)initWithMeetingPtr:(MeetingPtr)meeting;

@end

#include "JCFMeetingObserver.h"

struct MeetingOpaque
{
	
	MeetingOpaque(JCFMeeting* ObjcOwner, MeetingPtr meeting) 
	:mMeeting(meeting),
	mMeetingObserver(new JCFMeetingObserver(ObjcOwner))
	{
		mMeeting->addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingObserver>(mMeetingObserver));
	};
	
	~MeetingOpaque() 
	{
		mMeeting->removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingObserver>(mMeetingObserver));
	};
	
	MeetingPtr mMeeting;
	
private:
	MeetingObserverPtr mMeetingObserver;
};

@implementation JCFMeeting

@synthesize cpp = mMeetingCpp;

#pragma mark Base Unified Business Object Properties





-(NSString*) name
{
	
    std::string stringCpp = self.cpp->mMeeting->getName();
	return JCFNSStringForStdString(stringCpp);
	}


-(NSArray*) participants
{
	SMART_PTR_NS::shared_ptr<std::vector<SMART_PTR_NS::shared_ptr<CSFUnified::MeetingParticipant> > > vectorCPP;

	std::vector<SMART_PTR_NS::shared_ptr<CSFUnified::MeetingParticipant> >::const_iterator iter;

    vectorCPP = self.cpp->mMeeting->getParticipants();

    NSMutableArray *array= [NSMutableArray array];
    
    for (int i=0; i != vectorCPP->size(); i++)
    {
    
    [array addObject:[Forge(SMART_PTR_NS::static_pointer_cast<CSFUnified::UnifiedBusinessObject>(vectorCPP->at(i))) autorelease]];
    
    }
    return array;
}




#pragma mark Constructors

-(JCFMeeting*) initWithMeetingPtr:(MeetingPtr)meeting
{
	@synchronized([self class])
	{
		MeetingWPtr wp(meeting);
		MeetingCache::const_iterator iter = sCache.find(wp);
		if (iter != sCache.end())
		{
			[self release];
			self = [(*iter).second retain];
		}
		else
		{
			self = [super initSuperWithUnifiedBusinessObjectPtr : meeting];
			if (self != nil)
			{
				if ([self class] == [JCFMeeting class])
				{
					if (meeting != NULL)
					{
						self.cpp = new MeetingOpaque(self, meeting);
						sCache[wp] = self;
					}
					else
					{
						[self release];
						self = nil;
					}
				}
			}
		}
	}

	return self;
}

-(JCFMeeting*) initSuperWithMeetingPtr:(MeetingPtr)meeting
{
	self = [super initSuperWithUnifiedBusinessObjectPtr : meeting];

	if (self != nil)
	{
		if ([self class] == [JCFMeeting class])
		{
			if (meeting == NULL)
			{
				[self release];
				self = nil;
			}
		}
	}
	return self;
}

-(id) initWithPtr:(UnifiedBusinessObjectPtr) cppPtr
{
	MeetingPtr meeting = SMART_PTR_NS::dynamic_pointer_cast<CSFUnified::Meeting>(cppPtr);
	self = [self initWithMeetingPtr: meeting ];
	return self;
}

-(JCFMeeting*) init
{
    NSAssert(NO, @"init with initWithMeetingPtr:");
    [self release];
    self = nil;
	return nil;
}

+ (BOOL)automaticallyNotifiesObserversForKey:(NSString *)theKey {
	
	if([theKey isEqualToString:@"name"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"participants"])
	{
		return NO;
	}
	return [super automaticallyNotifiesObserversForKey:theKey];
}

+ (BOOL)accessInstanceVariablesDirectly
{
	return NO;
}

- (void)willChangeValueForKey:(NSString *)key
{
	kvoUpdate = YES;

	[super willChangeValueForKey:key];
}

- (void)didChangeValueForKey:(NSString *)key
{
	kvoUpdate = NO;
	[super didChangeValueForKey:key];
}

- (void)addObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
	
	if([keyPath hasPrefix:@"name"])
	{
		objc_setAssociatedObject(observer, &mName, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"participants"])
	{
		objc_setAssociatedObject(observer, &mParticipants, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}

	[super addObserver:observer forKeyPath:keyPath options:options context:context];
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath context:(void *)context
{
	[super removeObserver:observer forKeyPath:keyPath context:context];

	
	if([keyPath hasPrefix:@"name"])
	{
		objc_setAssociatedObject(observer, &mName, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"participants"])
	{
		objc_setAssociatedObject(observer, &mParticipants, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath
{
	[super removeObserver:observer forKeyPath:keyPath];

	
	if([keyPath hasPrefix:@"name"])
	{
		objc_setAssociatedObject(observer, &mName, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"participants"])
	{
		objc_setAssociatedObject(observer, &mParticipants, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

-(void)dealloc
{
	@synchronized([self class])
	{
		if (self.cpp != NULL)
		{
			MeetingWPtr wp(self.cpp->mMeeting);
			sCache.erase(wp);

	  		delete self.cpp;
  			self.cpp = NULL;
	  	}
	}

  	[super dealloc];
}

-(MeetingPtr) getMeetingPtr
{
	return self.cpp->mMeeting;
}



@end